package ru.yandex.direct.internaltools.tools.ecom.model

import ru.yandex.direct.core.entity.feed.service.MbiService
import ru.yandex.direct.internaltools.core.annotations.input.CheckBox
import ru.yandex.direct.internaltools.core.annotations.input.Input
import ru.yandex.direct.internaltools.core.annotations.input.Number
import ru.yandex.direct.internaltools.core.annotations.input.Text
import ru.yandex.direct.internaltools.core.container.InternalToolParameter

class AddEcomDomainParam : InternalToolParameter() {

    @Input(label = "Домен для добавления/обновления", description = "вместе со схемой, напр.: https://domain.ru")
    @Text
    var url: String = ""

    @Input(label = "Количество товаров с картинками",
        description = "берется из выгрузки самовара. Для существующих еком доменов количество товаров не будет изменено")
    @Number(defaultValue = MbiService.OFFERS_COUNT_FOR_PREVIEW.toLong(),
        minValue = MbiService.OFFERS_COUNT_FOR_PREVIEW.toLong())
    var offersCount: Long = 0

    @Input(label = "Домен не может быть удален")
    @CheckBox(checked = true)
    @get:JvmName("isPermanent")
    var permanent: Boolean = true
}
