package ru.yandex.direct.internaltools.tools.ecom.model

import com.fasterxml.jackson.annotation.JsonProperty
import ru.yandex.direct.core.entity.uac.model.EcomDomain

data class EcomDomainInfo(
    @JsonProperty("Действие") val action: String,
    @JsonProperty("Схема") val schema: String,
    @JsonProperty("Домен") val domain: String,
    @JsonProperty("Количество оферов") val offersCount: Long,
    val isPermanent: Boolean
) {
    constructor(action: EcomDomainAction, ecomDomain: EcomDomain) : this(
        action.toString(), ecomDomain.schema, ecomDomain.domain, ecomDomain.offersCount, ecomDomain.isPermanent
    )
}
