package ru.yandex.direct.internaltools.tools.ess;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableSet;
import org.springframework.stereotype.Component;

import ru.yandex.direct.ess.client.EssClient;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class LogicProcessorNamePreprocessor implements InternalToolInputPreProcessor<String> {

    private final EssClient essClient;

    public LogicProcessorNamePreprocessor(EssClient essClient) {
        this.essClient = essClient;
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        List<String> logicProcessorsNamesToChoose = new ArrayList<>();
        List<String> logicProcessorsNames =
                essClient.getLogicProcessorsNames().stream().sorted().collect(Collectors.toList());
        logicProcessorsNamesToChoose.add(null);
        logicProcessorsNamesToChoose.addAll(logicProcessorsNames);
        return inputBuilder
                .withDefaultValue(null)
                .withAllowedValues(logicProcessorsNamesToChoose)
                .addValidator(inSet(ImmutableSet.<String>builder().addAll(logicProcessorsNames).build()));
    }
}
