package ru.yandex.direct.internaltools.tools.ess.blacklist;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.ess.LogicProcessorNamePreprocessor;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class EssBlacklistAddParameters extends InternalToolParameter {
    public static final String FILTERS = "filters";

    @Input(label = "Имя logic processor'а", processors = LogicProcessorNamePreprocessor.class)
    @Select(preprocessed = true)
    private String essProcessName;

    @Input(label = "Шаблоны фильтров",
            description = "Можно вводить сразу несколько фильтров через запятую: " +
                    "{banner_id: 12345}, {banner_id: 12345}, ...")
    @TextArea(rows = 3)
    private String filters;

    public String getEssProcessName() {
        return essProcessName;
    }

    public EssBlacklistAddParameters withEssProcessName(String essProcesssName) {
        this.essProcessName = essProcesssName;
        return this;
    }

    public String getFilters() {
        return filters;
    }

    public EssBlacklistAddParameters withFilters(String filters) {
        this.filters = filters;
        return this;
    }
}
