package ru.yandex.direct.internaltools.tools.ess.blacklist;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.ess.LogicProcessorNamePreprocessor;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class EssBlacklistRemoveParameters extends InternalToolParameter {
    public static final String IDS = "ids";

    @Input(label = "Имя logic processor'а", processors = LogicProcessorNamePreprocessor.class)
    @Select(preprocessed = true)
    private String essProcessName;

    @Input(label = "Список ID ранее добавленных шаблонов",
            description = "ID должны быть отделены друг от друга запятой или любым whitespace символом")
    @TextArea(rows = 4)
    private String ids;

    public String getEssProcessName() {
        return essProcessName;
    }

    public EssBlacklistRemoveParameters withEssProcessName(String essProcesssName) {
        this.essProcessName = essProcesssName;
        return this;
    }

    public String getIds() {
        return ids;
    }

    public EssBlacklistRemoveParameters withIds(String ids) {
        this.ids = ids;
        return this;
    }
}
