package ru.yandex.direct.internaltools.tools.ess.blacklist;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.essblacklist.EssLogicObjectsBlacklistRepository;
import ru.yandex.direct.core.entity.essblacklist.model.EssBlacklistItem;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.isStringWithValidLongIds;

@Tool(
        name = "Удаление фильтров для объектов в ess-blacklist",
        label = "ess_blacklist_remove_tool",
        description = "Удаляет добавленные ранее фильтры объектов из blacklist-а",
        consumes = EssBlacklistRemoveParameters.class,
        type = InternalToolType.WRITER
)
@Category(InternalToolCategory.ESS)
@Action(InternalToolAction.DELETE)
@AccessGroup({InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPER})
@ParametersAreNonnullByDefault
public class EssBlacklistRemoveTool extends MassInternalTool<EssBlacklistRemoveParameters, EssBlacklistItem> {
    private final EssLogicObjectsBlacklistRepository essLogicObjectsRepository;

    @Autowired
    public EssBlacklistRemoveTool(EssLogicObjectsBlacklistRepository essLogicObjectsRepository) {
        this.essLogicObjectsRepository = essLogicObjectsRepository;
    }

    @Override
    public ValidationResult<EssBlacklistRemoveParameters, Defect> validate(EssBlacklistRemoveParameters parameters) {
        ItemValidationBuilder<EssBlacklistRemoveParameters, Defect> validationBuilder =
                ItemValidationBuilder.of(parameters);

        validationBuilder.item(parameters.getIds(), EssBlacklistRemoveParameters.IDS)
                .check(isStringWithValidLongIds(1));

        return validationBuilder.getResult();
    }

    @Override
    protected List<EssBlacklistItem> getMassData() {
        return essLogicObjectsRepository.getAll();
    }

    @Override
    protected List<EssBlacklistItem> getMassData(EssBlacklistRemoveParameters parameters) {
        Set<Long> ids = StreamEx.of(parameters.getIds().split("\\D+"))
                .map(Long::valueOf)
                .toSet();

        essLogicObjectsRepository.removeItems(parameters.getEssProcessName(), ids);

        return getMassData();
    }
}
