package ru.yandex.direct.internaltools.tools.ess.container;

public enum SendEssObjectsOption {
    VIEW_EXAMPLE_OBJECTS("Посмотреть примеры объектов"),
    SEND_OBJECTS("Отправить объекты");

    private String optionName;

    SendEssObjectsOption(String optionName) {
        this.optionName = optionName;
    }

    public String value() {
        return optionName;
    }

    public static SendEssObjectsOption fromValue(String stringOption) {
        for (var c : SendEssObjectsOption.values()) {
            if (c.optionName.equals(stringOption)) {
                return c;
            }
        }
        throw new IllegalArgumentException("Unknown send objects option " + stringOption);
    }
}
