package ru.yandex.direct.internaltools.tools.ess.container;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class SendLogicObjectsInfo {
    @JsonProperty("Статус")
    private String status;

    @JsonProperty("Пример объектов в топике за последние 3 дня")
    @Enrich(InternalToolDetailKey.ESS_LOGIC_OBJECTS_LINK)
    private String topic;

    public String getStatus() {
        return status;
    }

    public String getTopic() {
        return topic;
    }

    public SendLogicObjectsInfo withTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public SendLogicObjectsInfo withStatus(String status) {
        this.status = status;
        return this;
    }
}
