package ru.yandex.direct.internaltools.tools.ess.container;

import ru.yandex.direct.internaltools.core.annotations.input.File;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.ShardSelect;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.ess.LogicProcessorNamePreprocessor;
import ru.yandex.direct.internaltools.tools.ess.SendingObjectsToEssTool;

public class SendingObjectsParam extends InternalToolParameter {

    @Input(label = "Номер шарда", processors = ShardsPreprocessor.class)
    @ShardSelect
    private Integer shard;

    @Input(label = "Действие", processors = SendingObjectsToEssTool.SendEssObjectsOptionProcessor.class)
    @Select(preprocessed = true)
    private String optionName;

    @Input(label = "Имя logic processor'а", processors = LogicProcessorNamePreprocessor.class)
    @Select(preprocessed = true)
    private String logicProcessorName;

    @File
    @Input(label = "Файл для c объектами для отправки", required = false, description = "В файле объекты должны быть " +
            "в формате массива [{...},{...}]")
    private byte[] file;

    @Input(label = "Объекты для отправки", required = false, description = "Объекты должны быть переданы в формате " +
            "массива [{...},{...}]")
    @TextArea
    private String logicObjectsToSend;

    public Integer getShard() {
        return shard;
    }

    public String getLogicProcessorName() {
        return logicProcessorName;
    }

    public byte[] getFile() {
        return file;
    }

    public String getLogicObjectsToSend() {
        return logicObjectsToSend;
    }

    public String getOptionName() {
        return optionName;
    }
}
