package ru.yandex.direct.internaltools.tools.ess.container;

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.ImmutableSet;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class ShardsPreprocessor implements InternalToolInputPreProcessor<Integer> {

    private final List<Integer> shards;

    public ShardsPreprocessor(ShardHelper shardHelper) {
        this.shards = List.copyOf(shardHelper.dbShards());
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, Integer> preSend(
            InternalToolInput.Builder<T, Integer> inputBuilder) {
        var shardsToChoose = new ArrayList<Integer>();
        shardsToChoose.add(null);
        shardsToChoose.addAll(shards);
        return inputBuilder
                .withDefaultValue(null)
                .withAllowedValues(shardsToChoose)
                .addValidator(inSet(ImmutableSet.<Integer>builder().addAll(shards).build()));
    }
}
