package ru.yandex.direct.internaltools.tools.ess.mysql2grut.model

import com.fasterxml.jackson.annotation.JsonProperty
import ru.yandex.direct.internaltools.tools.ess.sendcampaign.service.RateLimitingService

class Mysql2GrutResendResultRow<out T>(
    @JsonProperty(" ")
    val name: String,

    @JsonProperty("  ")
    val value: T,
) {
    companion object {
        fun createResults(
            lastSentCampaign: Long?,
            totalObjects: Int,
        ): List<Mysql2GrutResendResultRow<*>> {
            val result = mutableListOf<Mysql2GrutResendResultRow<*>>()
            if (lastSentCampaign != null) {
                result.add(Mysql2GrutResendResultRow("Номер последней отправленной кампании", lastSentCampaign))
            }
            if (totalObjects == 0) {
                result.add(
                    Mysql2GrutResendResultRow(
                        "Ни одного объекта не отправлено, " +
                            "это может быть связано с ограничениями на количество отправляемых объектов, " +
                            "попробуйте через  ${RateLimitingService.TIME_WINDOW_MINUTES} минут", null as Any?
                    )
                )
            } else {
                result.add(Mysql2GrutResendResultRow("Отправлено объектов", totalObjects))
            }
            return result
        }
    }
}
