package ru.yandex.direct.internaltools.tools.ess.sendcampaign.model

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox
import ru.yandex.direct.internaltools.core.annotations.input.Input
import ru.yandex.direct.internaltools.core.annotations.input.MultipleSelect
import ru.yandex.direct.internaltools.core.annotations.input.TextArea
import ru.yandex.direct.internaltools.core.container.InternalToolParameter
import ru.yandex.direct.internaltools.tools.ess.sendcampaign.preprocessors.SendCampaignProcessorNamePreprocessor

class SendCampaignParam : InternalToolParameter() {
    @TextArea
    @Input(
        label = "Кампании для отправки",
        description = "Cid'ы кампаний",
    )
    var campaignsToSend: String = ""

    fun parseCampaignsToSend(): List<Long> =
        campaignsToSend
            .trim()
            .split(Regex("\\s+"))
            .filter(String::isNotBlank)
            .map(String::toLong)

    @MultipleSelect(preprocessed = true)
    @Input(
        label = "Игнорируемые объекты",
        required = false,
        description = "Объекты выбранных типов не будут читаться из базы и переотправляться в БК.\n" +
            "Для выбора надо зажать клавишу Command и выбрать нужные",
        processors = [SendCampaignProcessorNamePreprocessor::class]
    )
    var ignoredProcessors: MutableSet<String>? = null

    @CheckBox(checked = true)
    @Input(
        label = "Отправить объекты в ESS",
        description = "Можно не отправлять объекты в ESS, а просто посчитать, сколько их всего"
    )
    // internal tools ожидает, что поле будет называться sendingToEss, а геттер - isSendingToEss
    // JvmName к полю применить нельзя, поэтому приходится переименовывать геттер
    @get:JvmName("isSendingToEss")
    var sendingToEss: Boolean = true
}
