package ru.yandex.direct.internaltools.tools.ess.sendcampaign.model

import com.fasterxml.jackson.annotation.JsonProperty

data class SendCampaignResultRow<out T>(
    @JsonProperty(" ")
    val name: String,

    @JsonProperty("  ")
    val value: T,
) {
    companion object {
        fun createResults(
            lastSentCampaign: Long?,
            objectsAmounts: Map<String, Int>,
        ): List<SendCampaignResultRow<*>> {
            val result = mutableListOf<SendCampaignResultRow<*>>()

            if (lastSentCampaign != null) {
                result += lastSentCampaign(lastSentCampaign)
            }
            result += amountOfAllObjects(objectsAmounts.values.sum())
            result += objectsAmounts
                .map { (type, amount) ->
                    amountOfObjects(amount, type)
                }
                .sortedBy { it.name }

            return result
        }

        private fun lastSentCampaign(cid: Long) =
            SendCampaignResultRow(
                name = "Последняя обработанная кампания",
                value = cid,
            )

        private fun amountOfObjects(amount: Int, objectType: String) =
            SendCampaignResultRow(objectType, amount)

        private fun amountOfAllObjects(amount: Int) =
            SendCampaignResultRow("Всего объектов", amount)
    }
}
