package ru.yandex.direct.internaltools.tools.ess.sendcampaign.preprocessors

import org.springframework.stereotype.Component
import ru.yandex.direct.internaltools.core.container.InternalToolParameter
import ru.yandex.direct.internaltools.core.input.InternalToolInput
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor
import ru.yandex.direct.internaltools.tools.ess.sendcampaign.repository.CampaignContentRepository
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.result.Defect

@Component
class SendCampaignProcessorNamePreprocessor(
    private val repositories: List<CampaignContentRepository<*>>
) : InternalToolInputPreProcessor<String> {

    override fun <T : InternalToolParameter> preSend(
        inputBuilder: InternalToolInput.Builder<T, String>,
    ): InternalToolInput.Builder<T, String> {
        val logicProcessorsNames = repositories
            .map { it.logicProcessName }
            .sorted()

        val constraint = CommonConstraints.eachInSet(logicProcessorsNames.toSet())

        @Suppress("UNCHECKED_CAST")
        return inputBuilder
            .withDefaultValue(null)
            .withAllowedValues(logicProcessorsNames)
            .addValidator(constraint as Constraint<String, Defect<*>>)
    }
}
