package ru.yandex.direct.internaltools.tools.ess.sendcampaign.repository

import org.springframework.stereotype.Component
import ru.yandex.direct.dbschema.ppc.Tables.PHRASES
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.config.bsexport.adgroup.BsExportAdGroupConfig
import ru.yandex.direct.ess.config.bsexport.adgroup.BsExportAdGroupShowConditionConfig
import ru.yandex.direct.ess.logicobjects.bsexport.DebugInfo
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.tracing.Trace

abstract class CampaignBaseAdGroupsRepository<T : BaseLogicObject>(
    private val dslContextProvider: DslContextProvider,
) : CampaignContentRepository<T> {

    override fun getObjectsByCids(shard: Int, cids: Collection<Long>): Map<Long, List<T>> =
        dslContextProvider.ppc(shard)
            .select(PHRASES.PID, PHRASES.CID)
            .from(PHRASES)
            .where(PHRASES.CID.`in`(cids))
            .fetchGroups(PHRASES.CID) { (pid, cid) -> buildLogicObject(pid, cid) }

    abstract fun buildLogicObject(pid: Long, cid: Long): T
}

@Component
class CampaignAdGroupShowConditionsRepository(
    dslContextProvider: DslContextProvider
) : CampaignBaseAdGroupsRepository<BsExportAdGroupShowConditionObject>(dslContextProvider) {

    override val logicProcessName: String = BsExportAdGroupShowConditionConfig().logicProcessName

    override fun buildLogicObject(pid: Long, cid: Long) =
        BsExportAdGroupShowConditionObject(
            adGroupId = pid,
            campaignId = cid,
            type = AdGroupShowConditionType.ALL,
            debugInfo = Trace.current().toDebugInfo(),
        )
}

@Component
class CampaignAdGroupsRepository(
    dslContextProvider: DslContextProvider
) : CampaignBaseAdGroupsRepository<BsExportAdGroupObject>(dslContextProvider) {

    override val logicProcessName: String = BsExportAdGroupConfig().logicProcessName

    override fun buildLogicObject(pid: Long, cid: Long) =
        BsExportAdGroupObject(
            resourceType = AdGroupResourceType.ALL,
            adGroupId = pid,
            campaignId = cid,
            debugInfo = Trace.current().toDebugInfo(),
        )
}

private fun Trace.toDebugInfo(): DebugInfo =
    DebugInfo(
        reqid = spanId,
        service = service,
        method = method,
    )
