package ru.yandex.direct.internaltools.tools.ess.sendcampaign.repository

import org.springframework.stereotype.Component
import ru.yandex.direct.dbschema.ppc.Tables.BANNERS
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.ess.config.bsexport.resources.BsExportBannerResourcesConfig
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject
import ru.yandex.direct.tracing.Trace

@Component
class CampaignBannerResourcesRepository(
    private val dslContextProvider: DslContextProvider,
) : CampaignContentRepository<BsExportBannerResourcesObject> {

    override val logicProcessName: String = BsExportBannerResourcesConfig().logicProcessName

    data class BannerInfo(
        val bid: Long,
        val bannerId: Long,
        val pid: Long,
        val cid: Long,
    )

    override fun getObjectsByCids(shard: Int, cids: Collection<Long>) =
        dslContextProvider.ppc(shard)
            .select(BANNERS.BID, BANNERS.BANNER_ID, BANNERS.PID, BANNERS.CID)
            .from(BANNERS)
            .where(BANNERS.CID.`in`(cids))
            .fetchGroups(BANNERS.CID) { (bid, bannerId, pid, cid) ->
                val banner = BannerInfo(bid, bannerId, pid, cid)
                buildBannerLogicObject(banner)
            }

    private fun buildBannerLogicObject(banner: BannerInfo): BsExportBannerResourcesObject =
        BsExportBannerResourcesObject.Builder().run {
            setCid(banner.cid)
            setPid(banner.pid)
            setBid(banner.bid)
            setBannerId(banner.bannerId)
            setResourceType(BannerResourceType.ALL)

            val trace = Trace.current()
            setMethod(trace.method)
            setReqid(trace.spanId)
            setService(trace.service)

            build()
        }
}
