package ru.yandex.direct.internaltools.tools.ess.sendcampaign.repository

import org.springframework.stereotype.Component
import ru.yandex.direct.core.bsexport.model.BsExportAbstractBid
import ru.yandex.direct.core.bsexport.repository.bids.BsExportBidsDynamicRepository
import ru.yandex.direct.core.bsexport.repository.bids.BsExportBidsKeywordRepository
import ru.yandex.direct.core.bsexport.repository.bids.BsExportBidsOfferRetargetingRepository
import ru.yandex.direct.core.bsexport.repository.bids.BsExportBidsPerformanceRepository
import ru.yandex.direct.core.bsexport.repository.bids.BsExportBidsRelevanceMatchRepository
import ru.yandex.direct.core.bsexport.repository.bids.BsExportBidsRetargetingRepository
import ru.yandex.direct.ess.config.bsexport.bids.BsExportBiddableShowConditionsConfig
import ru.yandex.direct.ess.logicobjects.bsexport.bids.BidObjectType
import ru.yandex.direct.ess.logicobjects.bsexport.bids.BsExportBidsObject
import ru.yandex.direct.tracing.Trace

@Component
class CampaignBiddableShowConditionsRepository(
    bsExportBidsDynamicRepository: BsExportBidsDynamicRepository,
    bsExportBidsKeywordRepository: BsExportBidsKeywordRepository,
    bsExportBidsPerformanceRepository: BsExportBidsPerformanceRepository,
    bidsOfferRetargetingRepository: BsExportBidsOfferRetargetingRepository,
    bsExportBidsRelevanceMatchRepository: BsExportBidsRelevanceMatchRepository,
    bsExportBidsRetargetingRepository: BsExportBidsRetargetingRepository,
) : CampaignContentRepository<BsExportBidsObject> {

    private val repositories = mapOf(
        BidObjectType.DYNAMIC to bsExportBidsDynamicRepository,
        BidObjectType.KEYWORD to bsExportBidsKeywordRepository,
        BidObjectType.PERFORMANCE to bsExportBidsPerformanceRepository,
        BidObjectType.OFFER_RETARGETING to bidsOfferRetargetingRepository,
        BidObjectType.RELEVANCE_MATCH to bsExportBidsRelevanceMatchRepository,
        BidObjectType.RETARGETING to bsExportBidsRetargetingRepository,
    )

    override val logicProcessName: String = BsExportBiddableShowConditionsConfig().logicProcessName

    override fun getObjectsByCids(shard: Int, cids: Collection<Long>): Map<Long, List<BsExportBidsObject>> =
        repositories
            .asSequence()
            .flatMap { (type, repository) ->
                repository
                    .getBidsByCids(shard, cids.toList(), limit = Int.MAX_VALUE, from = null)
                    .map { buildBidLogicObject(it, type) }
            }
            .groupBy { checkNotNull(it.cid) }

    private fun buildBidLogicObject(bid: BsExportAbstractBid, type: BidObjectType): BsExportBidsObject =
        BsExportBidsObject(bid.campaignId, bid.adGroupId, bid.id, type, false).apply {
            val trace = Trace.current()
            reqid = trace.spanId
            service = trace.service
            method = trace.method
        }
}
