package ru.yandex.direct.internaltools.tools.ess.sendcampaign.repository

import org.springframework.stereotype.Component
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.ess.config.bsexport.campaign.BsExportCampaignConfig
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.tracing.Trace

@Component
class CampaignSelfRepository(
    private val dslContextProvider: DslContextProvider,
) : CampaignContentRepository<BsExportCampaignObject> {

    override val logicProcessName: String = BsExportCampaignConfig().logicProcessName

    override fun getObjectsByCids(shard: Int, cids: Collection<Long>) =
        dslContextProvider.ppc(shard)
            .select(CAMPAIGNS.CID, CAMPAIGNS.ORDER_ID)
            .from(CAMPAIGNS)
            .where(CAMPAIGNS.CID.`in`(cids))
            .fetchMap(CAMPAIGNS.CID) { (cid, orderId) ->
                listOf(buildCampaignLogicObject(cid, orderId))
            }

    private fun buildCampaignLogicObject(cid: Long, orderId: Long): BsExportCampaignObject =
        BsExportCampaignObject.Builder().setCid(cid).run {
            setOrderId(orderId)
            setCampaignResourceType(CampaignResourceType.ALL)
            setMethod(Trace.current().method)
            setReqid(Trace.current().spanId)
            setService(Trace.current().service)
            build()
        }
}
