package ru.yandex.direct.internaltools.tools.ess.sendcampaign.validation

import ru.yandex.direct.i18n.I18NBundle
import ru.yandex.direct.i18n.Translatable
import ru.yandex.direct.i18n.bundle.MessageFormatStub
import ru.yandex.direct.i18n.bundle.TranslationBundle
import ru.yandex.direct.internaltools.tools.ess.sendcampaign.service.RateLimitingService.Companion.TIME_WINDOW_MINUTES

interface SendCampaignDefectTranslations : TranslationBundle {
    @MessageFormatStub("За последние $TIME_WINDOW_MINUTES минут было отправлено более {0} объектов, попробуйте через {1} секунд")
    fun timeoutIsActive(objectsLimit: Int, secondsRemain: Long): Translatable?

    companion object {
        @JvmField
        val INSTANCE = I18NBundle.implement(SendCampaignDefectTranslations::class.java)
    }
}
