package ru.yandex.direct.internaltools.tools.ess.sendcampaign.validation

import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.DefectId

data class SendCampaignDefectParams(
    val objectsSent: Int,
    val secondsRemain: Long,
)

enum class SendCampaignDefectIds : DefectId<SendCampaignDefectParams> {
    TIMEOUT_IS_ACTIVE,
}

object SendCampaignDefects {
    fun timeoutIsActive(
        objectsLimit: Int,
        secondsRemain: Long,
    ) = Defect(SendCampaignDefectIds.TIMEOUT_IS_ACTIVE, SendCampaignDefectParams(objectsLimit, secondsRemain))
}
