package ru.yandex.direct.internaltools.tools.essmoderation.beta;

import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.Attributes;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.ModerationServiceNames;

@JsonIgnoreProperties(ignoreUnknown=true)
class ModerationLogEntryData {
    // сервис, который прислал запрос. Обычно равен direct
    @JsonProperty("service")
    private ModerationServiceNames service;

    //тип заявки, которая обрабатывалась
    @JsonProperty("type")
    private ModerationObjectType type;

    @JsonProperty("unixtime")
    private long unixtime;

    @JsonProperty("attributes")
    private Attributes attributes;

    public ModerationServiceNames getService() {
        return service;
    }

    public void setService(ModerationServiceNames service) {
        this.service = service;
    }

    @Nullable
    public ModerationObjectType getType() {
        return type;
    }

    public void setType(ModerationObjectType type) {
        this.type = type;
    }

    public long getUnixtime() {
        return unixtime;
    }

    public void setUnixtime(long unixtime) {
        this.unixtime = unixtime;
    }

    public Attributes getAttributes() {
        return attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ModerationLogEntryData data = (ModerationLogEntryData) o;
        return unixtime == data.unixtime &&
                Objects.equals(service, data.service) &&
                Objects.equals(type, data.type) &&
                Objects.equals(attributes, data.attributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(service.getValue(), type, unixtime, attributes);
    }

    @Override
    public String toString() {
        return "ModerationData{" +
                "service='" + service + "', " +
                "type='" + type + "', " +
                "unixtime=" + unixtime + ", " +
                "attributes=" + attributes +
                '}';
    }
}
