package ru.yandex.direct.internaltools.tools.essmoderation.beta;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.DateTime;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Number;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class ReceiveFromModerationParameter extends InternalToolParameter {
    @Input(label = "Ess-tag",
            description = "Тег для фильтрации вердиктов, подлежащих обработке. В обработку будут попадать " +
                    "только те вердикты, которые помечены этим тегом.")
    private String essTag;

    @Input(label = "Обрабатывать вердикты на запросы, отправленные после (время московское)",
            description = "Будут обработаны только вердикты на запросы, отправленные позднее указаного времени.")
    @DateTime()
    private LocalDateTime minRequestSendTime;

    @Input(label = "Длительность работы процесса (в секундах)",
            description = "Чем больше событий произошло в системе после указанного в предыдущем параметре времени, " +
                    "тем больше времени потребуется на их обработку.")
    @Number(defaultValue = 100, minValue = 20, maxValue = 600)
    private Long durationInSec;

    public String getEssTag() {
        return essTag;
    }

    public ReceiveFromModerationParameter withEssTag(String essTag) {
        this.essTag = essTag;
        return this;
    }

    public LocalDateTime getMinRequestSendTime() {
        return minRequestSendTime;
    }

    public ReceiveFromModerationParameter withMinRequestSentTime(LocalDateTime minRequestSendTime) {
        this.minRequestSendTime = minRequestSendTime;
        return this;
    }

    public Long getDurationInSec() {
        return durationInSec;
    }

    public ReceiveFromModerationParameter withDurationInSec(Long durationInSec) {
        this.durationInSec = durationInSec;
        return this;
    }
}
