package ru.yandex.direct.internaltools.tools.essmoderation.beta;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.BetaOnly;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.process.ProcessExitStatusException;

import static ru.yandex.direct.process.Processes.checkCall;

@Tool(
        name = "Получить вердикты модерации",
        label = "receive_from_ess_moderation",
        description = "Получение вердиктов из ess модерации",
        consumes = ReceiveFromModerationParameter.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.RECEIVE)
@Category(InternalToolCategory.MODERATE)
@AccessGroup({InternalToolAccessRole.INTERNAL_USER})
@BetaOnly
@ParametersAreNonnullByDefault
public class ReceiveFromModerationTool implements BaseInternalTool<ReceiveFromModerationParameter> {

    @Override
    public InternalToolResult process(ReceiveFromModerationParameter receiveFromModerationParameter) {
        LogFilesReader logReader = new LogFilesReader(Paths.get("../jobs"), "ess_moderation");
        LocalDateTime startTime = LocalDateTime.now();

        try {
            runReceiveFromModeration(receiveFromModerationParameter);
            List<ModerationLogEntry<ModerationLogEntryData>> log = logReader.readEntries(startTime);
            return new InternalToolResult("Receiving complete.\n\nFull log:\n" + StreamEx.of(log).joining("\n"));
        } catch (InterruptedException | ProcessExitStatusException | IOException e) {
            Thread.currentThread().interrupt();
            return new InternalToolResult("Receiving failed.\n" + e.toString());
        }
    }

    private void runReceiveFromModeration(ReceiveFromModerationParameter receiveFromModerationParameter)
            throws InterruptedException {
        Path betaDir = Paths.get("").toAbsolutePath().resolve("../../..").normalize();

        String[] receiveModerationCommandParts = {
                "/usr/local/bin/direct-mk run_receive_moderation --",
                "--job", "ReceiveModerationResponseJob",
                "--ess-tag", receiveFromModerationParameter.getEssTag(),
                "--working-time", receiveFromModerationParameter.getDurationInSec().toString(),
                "--read-data-sent-after", receiveFromModerationParameter.getMinRequestSendTime().toString()
        };
        var processBuilder = new ProcessBuilder()
                .directory(betaDir.toFile())
                .command("/bin/bash", "-c", String.join(" ", receiveModerationCommandParts));

        checkCall(processBuilder);
    }
}
