package ru.yandex.direct.internaltools.tools.essmoderation.beta;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.DateTime;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Number;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class SendToModerationParameter extends InternalToolParameter {
    @Input(label = "Ess-tag", description = "Тег для фильтрации событий, подлежащих обработке. В обработку будут " +
            "попадать только те события, которые помечены этим тегом.\n" +
            "Тегом может быть что угодно, что верноятно больше никто не будет использовать: логин, номер задачи, " +
            "номер беты и тд.\n" +
            "Этот тег должен был быть указан при создании беты.")
    private String essTag;

    @Input(label = "Обрабатывать события после (время московское)",
            description = "Из логброкера будут прочитаны только те события, которые случились " +
                    "позднее указаного времени.")
    @DateTime(now = true)
    private LocalDateTime minEventTime;

    @Input(label = "Длительность работы процесса (в секундах)",
            description = "Чем больше событий произошло в системе после указанного в предыдущем параметре времени, " +
                    "тем больше времени потребуется на их обработку.")
    @Number(defaultValue = 100, minValue = 20, maxValue = 600)
    private Long durationInSec;

    public String getEssTag() {
        return essTag;
    }

    public SendToModerationParameter withEssTag(String essTag) {
        this.essTag = essTag;
        return this;
    }

    public LocalDateTime getMinEventTime() {
        return minEventTime;
    }

    public SendToModerationParameter withMinEventTime(LocalDateTime minEventTime) {
        this.minEventTime = minEventTime;
        return this;
    }

    public Long getDurationInSec() {
        return durationInSec;
    }

    public SendToModerationParameter withDurationInSec(Long durationInSec) {
        this.durationInSec = durationInSec;
        return this;
    }
}
