package ru.yandex.direct.internaltools.tools.essmoderation.beta;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.ess.common.models.EssGroup;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.BetaOnly;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.process.ProcessExitStatusException;

import static ru.yandex.direct.process.Processes.checkCall;

@Tool(
        name = "Отправить на модерацию",
        label = "send_to_ess_moderation",
        description = "Отправка объектов в ess модерацию",
        consumes = SendToModerationParameter.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.SEND)
@Category(InternalToolCategory.MODERATE)
@AccessGroup({InternalToolAccessRole.INTERNAL_USER})
@BetaOnly
@ParametersAreNonnullByDefault
public class SendToModerationTool implements BaseInternalTool<SendToModerationParameter> {

    @Override
    public InternalToolResult process(SendToModerationParameter sendToModerationParameter) {
        LogFilesReader logReader = new LogFilesReader(Paths.get("../apps/event-sourcing-system/full-ess-chain"),
                "ess_moderation");
        LocalDateTime startTime = LocalDateTime.now();

        try {
            runEssChain(sendToModerationParameter);
            List<ModerationLogEntry<ModerationLogEntryData>> log = logReader.readEntries(startTime);
            return new InternalToolResult("Sending complete.\n\nFull log:\n" + StreamEx.of(log).joining("\n"));
        } catch (InterruptedException | ProcessExitStatusException | IOException e) {
            Thread.currentThread().interrupt();
            return new InternalToolResult("Sending failed.\n" + e.toString());
        }
    }

    private void runEssChain(SendToModerationParameter sendToModerationParameter) throws InterruptedException {
        Path betaDir = Paths.get("").toAbsolutePath().resolve("../../..").normalize();

        String[] essChainCommandParts = {
                "/usr/local/bin/direct-mk run_ess_chain --",
                "--ess-group", EssGroup.BANNER_MODERATION.name(),
                "--ess-tag", sendToModerationParameter.getEssTag(),
                "--working-time", sendToModerationParameter.getDurationInSec().toString(),
                "--read-data-after", sendToModerationParameter.getMinEventTime().toString()
        };
        var processBuilder = new ProcessBuilder()
                .directory(betaDir.toFile())
                .command("/bin/bash", "-c", String.join(" ", essChainCommandParts));

        checkCall(processBuilder);
    }

}
