package ru.yandex.direct.internaltools.tools.essmoderation.model;


import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class EnableEssModerationParameter extends InternalToolParameter {

    public static final String OBJECT_TYPE_PROPERTY = "objectType";
    public static final String OBJECT_ID_PROPERTY = "objectId";

    @Input(label = "Тип объекта")
    private EnableEssModerationObjectType objectType;

    @Input(label = "ID объекта")
    private Long objectId;

    @Input(label = "Удалить?")
    @CheckBox(checked = false)
    private Boolean toRemove;

    public EnableEssModerationObjectType getObjectType() {
        return objectType;
    }

    public EnableEssModerationParameter withObjectType(EnableEssModerationObjectType objectType) {
        this.objectType = objectType;
        return this;
    }

    public Long getObjectId() {
        return objectId;
    }

    public EnableEssModerationParameter withObjectId(Long objectId) {
        this.objectId = objectId;
        return this;
    }

    public Boolean getToRemove() {
        return toRemove;
    }

    public EnableEssModerationParameter withToRemove(Boolean toRemove) {
        this.toRemove = toRemove;
        return this;
    }
}
