package ru.yandex.direct.internaltools.tools.feature.container;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class AbConditionsCheckParam extends InternalToolParameter {
    @Input(label = "Условие", required = true)
    private String condition;
    @Input(label = "ClientId", required = false)
    private Long clientId;
    @Input(label = "Логин", required = false)
    private String login;

    public String getCondition() {
        return condition;
    }

    public AbConditionsCheckParam withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public AbConditionsCheckParam withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getLogin() {
        return login;
    }

    public AbConditionsCheckParam withLogin(String login) {
        this.login = login;
        return this;
    }

    @Override
    public String toString() {
        return "AbConditionsCheckParam{" +
                "condition='" + condition + '\'' +
                ", clientId=" + clientId +
                ", login='" + login + '\'' +
                '}';
    }
}
