package ru.yandex.direct.internaltools.tools.feature.container;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class InternalToolClientsUaasFeature {
    @JsonProperty("test id")
    @Enrich(InternalToolDetailKey.ABT_TESTID_LINK)
    private String testId;

    @JsonProperty("фичи")
    private List<String> features;

    @JsonProperty("Условие отбора")
    private String condition;

    public String getTestId() {
        return testId;
    }

    public InternalToolClientsUaasFeature withTestId(String testIds) {
        this.testId = testIds;
        return this;
    }

    public List<String> getFeatures() {
        return features;
    }

    public InternalToolClientsUaasFeature withFeatures(List<String> features) {
        this.features = features;
        return this;
    }

    public String getCondition() {
        return condition;
    }

    public InternalToolClientsUaasFeature withCondition(String condition) {
        this.condition = condition;
        return this;
    }
}
