package ru.yandex.direct.internaltools.tools.feature.container;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class InternalToolsAddFeatureInfo {

    @JsonProperty("id фичи")
    private Long featureId;

    @JsonProperty("Ключ фичи")
    private String featureTextId;

    @JsonProperty("Тикет")
    @Enrich(InternalToolDetailKey.STARTREK_TICKET_LINK_REPLACE)
    private String featureTicket;

    @JsonProperty("Название")
    private String featurePublicName;

    @JsonProperty("Включена на 100%")
    private String isTurnOn;

    @JsonProperty("Клиенты вкл/выкл")
    private String clientSummary;

    @JsonProperty("Публичность")
    private String isPublic;

    @JsonProperty("Изначально ответственный за фичу")
    private String originalOwner;

    @JsonProperty("Изначальные наблюдатели")
    private String originalWatchers;

    public Long getFeatureId() {
        return featureId;
    }

    public InternalToolsAddFeatureInfo withFeatureId(Long featureId) {
        this.featureId = featureId;
        return this;
    }

    public String getFeatureTextId() {
        return featureTextId;
    }

    public InternalToolsAddFeatureInfo withFeatureTextId(String featureTextId) {
        this.featureTextId = featureTextId;
        return this;
    }

    public String getFeatureTicket() {
        return featureTicket;
    }

    public InternalToolsAddFeatureInfo withFeatureTicket(String featureTicket) {
        this.featureTicket = featureTicket;
        return this;
    }

    public String getFeaturePublicName() {
        return featurePublicName;
    }

    public InternalToolsAddFeatureInfo withFeaturePublicName(String featurePublicName) {
        this.featurePublicName = featurePublicName;
        return this;
    }

    public String getIsTurnOn() {
        return isTurnOn;
    }

    public InternalToolsAddFeatureInfo withIsTurnOn(String isTurnOn) {
        this.isTurnOn = isTurnOn;
        return this;
    }

    public String getClientSummary() {
        return clientSummary;
    }

    public InternalToolsAddFeatureInfo withClientSummary(String clientSummary) {
        this.clientSummary = clientSummary;
        return this;
    }

    public String getIsPublic() {
        return isPublic;
    }

    public InternalToolsAddFeatureInfo withIsPublic(String isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    public String getOriginalOwner() {
        return originalOwner;
    }

    public InternalToolsAddFeatureInfo withOriginalOwner(String owner) {
        this.originalOwner = owner;
        return this;
    }

    public String getOriginalWatchers() {
        return originalWatchers;
    }

    public InternalToolsAddFeatureInfo withOriginalWatchers(String watchers) {
        this.originalWatchers = watchers;
        return this;
    }
}
