package ru.yandex.direct.internaltools.tools.feature.container;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class InternalToolsAddFeaturesParams extends InternalToolParameter {

    private static final String FEATURE_NAME_URL = "https://a.yandex-team.ru/arc/trunk/arcadia/direct/libs-internal" +
            "/base-model/src/main/java/ru/yandex/direct/feature/FeatureName.java";

    @Input(label = "Ключ фичи для добавления",
            description = "из enum-a <a href=\"" + FEATURE_NAME_URL + "\" target=\"_blank\">FeatureName</a>")
    @Text
    private String featureTextId;

    @Input(label = "Ответственный за фичу", description = "логин на staff")
    @Text
    private String owner;

    @Input(label = "Наблюдатели", description = "логины на staff, через запятую", required = false)
    @Text
    private String watchers;

    @Input(label = "Фича для всех клиентов агенств", required = false)
    @CheckBox(checked = false)
    private Boolean isAgencyFeature;

    @Input(label = "Клиент может управлять фичей из web", required = false)
    @CheckBox(checked = false)
    private Boolean clientCanSwitch;

    public String getFeatureTextId() {
        return featureTextId;
    }

    public void setFeatureTextId(String featureTextId) {
        this.featureTextId = featureTextId;
    }

    public Boolean getIsAgencyFeature() {
        return isAgencyFeature;
    }

    public void setIsAgencyFeature(Boolean agencyFeature) {
        isAgencyFeature = agencyFeature;
    }

    public Boolean getClientCanSwitch() {
        return clientCanSwitch;
    }

    public void setClientCanSwitch(Boolean clientCanSwitch) {
        this.clientCanSwitch = clientCanSwitch;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getWatchers() {
        return watchers;
    }

    public void setWatchers(String watchers) {
        this.watchers = watchers;
    }
}
