package ru.yandex.direct.internaltools.tools.feature.container;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class InternalToolsClientFeature {
    @JsonProperty("ClientID")
    private Long clientId;

    @JsonProperty("login главного представителя")
    private String chiefLogin;

    @JsonProperty("uid главного представителя")
    private Long chiefUid;

    @JsonProperty("Доступ")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isEnabled;

    public Long getClientId() {
        return clientId;
    }

    public InternalToolsClientFeature withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Boolean getIsEnabled() {
        return isEnabled;
    }

    public InternalToolsClientFeature withIsEnabled(Boolean enabled) {
        isEnabled = enabled;
        return this;
    }

    public String getChiefLogin() {
        return chiefLogin;
    }

    public InternalToolsClientFeature withChiefLogin(String chiefLogin) {
        this.chiefLogin = chiefLogin;
        return this;
    }

    public Long getChiefUid() {
        return chiefUid;
    }

    public InternalToolsClientFeature withChiefUid(Long uid) {
        this.chiefUid = uid;
        return this;
    }
}
