package ru.yandex.direct.internaltools.tools.feature.container;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.feature.FeatureType;
import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class InternalToolsFeature {
    @JsonProperty("id")
    private Long id;

    @JsonProperty("Ключ фичи")
    private String featureTextId;

    @JsonProperty("Название")
    private String featurePublicName;

    @JsonProperty("Тикет")
    @Enrich(InternalToolDetailKey.STARTREK_TICKET_LINK_REPLACE)
    private String featureTicket;

    @JsonProperty("Запись розыгрыша")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isAccessibleAfterDisabling;

    @JsonProperty("Подключенные роли")
    private Set<String> roles;

    @JsonProperty("Включено на процент")
    private Integer percent;

    @JsonProperty("Роли, которые могут включать")
    private Set<String> canEnable;

    @JsonProperty("Роли, которые могут выключать")
    private Set<String> canDisable;

    @JsonProperty("Публичность фичи")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isPublic;

    @JsonProperty("Тип фичи")
    private FeatureType featureType;

    public Long getId() {
        return id;
    }

    public InternalToolsFeature withId(Long id) {
        this.id = id;
        return this;
    }

    public String getFeatureTextId() {
        return featureTextId;
    }

    public InternalToolsFeature withFeatureTextId(String featureTextId) {
        this.featureTextId = featureTextId;
        return this;
    }

    public String getFeaturePublicName() {
        return featurePublicName;
    }

    public InternalToolsFeature withFeaturePublicName(String featurePublicName) {
        this.featurePublicName = featurePublicName;
        return this;
    }

    public String getFeatureTicket() {
        return featureTicket;
    }

    public InternalToolsFeature withFeatureTicket(String featureTicket) {
        this.featureTicket = featureTicket;
        return this;
    }

    public Boolean getIsAccessibleAfterDisabling() {
        return isAccessibleAfterDisabling;
    }

    public InternalToolsFeature withIsAccessibleAfterDisabling(Boolean accessibleAfterDisabling) {
        isAccessibleAfterDisabling = accessibleAfterDisabling;
        return this;
    }

    public Set<String> getRoles() {
        return roles;
    }

    public InternalToolsFeature withRoles(Set<String> roles) {
        this.roles = roles;
        return this;
    }

    public Integer getPercent() {
        return percent;
    }

    public InternalToolsFeature withPercent(Integer percent) {
        this.percent = percent;
        return this;
    }

    public Set<String> getCanEnable() {
        return canEnable;
    }

    public InternalToolsFeature withCanEnable(Set<String> canEnable) {
        this.canEnable = canEnable;
        return this;
    }

    public Set<String> getCanDisable() {
        return canDisable;
    }

    public InternalToolsFeature withCanDisable(Set<String> canDisable) {
        this.canDisable = canDisable;
        return this;
    }

    public Boolean getIsPublic() {
        return isPublic;
    }

    public InternalToolsFeature withIsPublic(Boolean isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    public FeatureType getFeatureType() {
        return featureType;
    }

    public InternalToolsFeature withFeatureType(FeatureType featureType) {
        this.featureType = featureType;
        return this;
    }
}
