package ru.yandex.direct.internaltools.tools.feature.container;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class InternalToolsFeatureIdClientIdsState extends InternalToolParameter {
    public static final String ID = "FEATURE_TEXT_ID";
    public static final String CLIENT_IDS = "CLIENT_IDS";
    @Input(label = "Ключ фичи")
    private String featureTextId;

    @Input(label = "ClientId клиентов, через запятую")
    @TextArea
    private String clientIds;

    @Input(label = "Включить фичу")
    @CheckBox(checked = true)
    private Boolean state;

    @Input(label = "Сбросить фичу", required = false)
    @CheckBox(checked = false)
    private Boolean reset;

    public String getFeatureTextId() {
        return featureTextId;
    }

    public InternalToolsFeatureIdClientIdsState withFeatureTextId(String featureTextId) {
        this.featureTextId = featureTextId;
        return this;
    }

    public String getClientIds() {
        return clientIds;
    }

    public InternalToolsFeatureIdClientIdsState withClientIds(String clientIds) {
        this.clientIds = clientIds;
        return this;
    }

    public Boolean getState() {
        return state;
    }

    public InternalToolsFeatureIdClientIdsState withState(Boolean state) {
        this.state = state;
        return this;
    }

    public Boolean getReset() {
        return reset;
    }

    public InternalToolsFeatureIdClientIdsState withReset(Boolean reset) {
        this.reset = reset;
        return this;
    }
}
