package ru.yandex.direct.internaltools.tools.feature.container;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class InternalToolsFeatureIdClientLoginsState extends InternalToolParameter {
    public static final String ID = "FEATURE_TEXT_ID";
    public static final String LOGINS = "LOGINS";
    @Input(label = "Ключ фичи")
    private String featureTextId;

    @Input(label = "Логины клиентов, через запятую")
    @TextArea
    private String clientLogins;

    @Input(label = "включить фичу")
    @CheckBox(checked = true)
    private Boolean state;

    @Input(label = "сбросить фичу", required = false)
    @CheckBox(checked = false)
    private Boolean reset;

    public String getFeatureTextId() {
        return featureTextId;
    }

    public InternalToolsFeatureIdClientLoginsState withTextFeatureId(String featureTextId) {
        this.featureTextId = featureTextId;
        return this;
    }

    public String getClientLogins() {
        return clientLogins;
    }

    public InternalToolsFeatureIdClientLoginsState withClientLogins(String clientLogins) {
        this.clientLogins = clientLogins;
        return this;
    }

    public Boolean getState() {
        return state;
    }

    public InternalToolsFeatureIdClientLoginsState withState(Boolean state) {
        this.state = state;
        return this;
    }

    public Boolean getReset() {
        return reset;
    }

    public InternalToolsFeatureIdClientLoginsState withReset(Boolean reset) {
        this.reset = reset;
        return this;
    }
}
