package ru.yandex.direct.internaltools.tools.feature.container;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Number;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class InternalToolsFeaturePercent extends InternalToolParameter {
    public static final String FEATURE_TEXT_ID = "FEATURE_TEXT_ID";
    public static final String PERCENT = "PERCENT";
    @Input(label = "ключ фичи")
    private String textId;

    @Input(label = "процент")
    @Number(defaultValue = 1)
    private Long percent;

    public String getTextId() {
        return textId;
    }

    public InternalToolsFeaturePercent withTextId(String id) {
        this.textId = id;
        return this;
    }

    public Long getPercent() {
        return percent;
    }

    public InternalToolsFeaturePercent withPercent(Long percent) {
        this.percent = percent;
        return this;
    }
}
