package ru.yandex.direct.internaltools.tools.feature.container;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class InternalToolsFeaturePublicity {
    @JsonProperty("Ключ фичи")
    private String textId;

    @JsonProperty("Публичность")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isPublic;

    public String getTextId() {
        return textId;
    }

    public InternalToolsFeaturePublicity withTextId(String textId) {
        this.textId = textId;
        return this;
    }

    public Boolean getIsPublic() {
        return isPublic;
    }

    public InternalToolsFeaturePublicity withIsPublic(Boolean isPublic) {
        this.isPublic = isPublic;
        return this;
    }
}
