package ru.yandex.direct.internaltools.tools.feature.container;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class InternalToolsFeaturePublicityState extends InternalToolParameter {
    public static final String FEATURE_TEXT_ID = "FEATURE_TEXT_ID";
    public static final String PUBLICITY_ACTION = "PUBLICITY_ACTION";

    @Input(label = "Ключ фичи")
    private String textId;

    @Select
    @Input(label = "Действие")
    private Action action;

    public enum Action {
        ENABLE_PUBLICITY("Сделать публичной"),
        DISABLE_PUBLICITY("Сделать непубличной");

        private final String description;

        Action(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    public String getTextId() {
        return textId;
    }

    public InternalToolsFeaturePublicityState withTextId(String textId) {
        this.textId = textId;
        return this;
    }

    public Action getAction() {
        return action;
    }

    public InternalToolsFeaturePublicityState withAction(Action action) {
        this.action = action;
        return this;
    }

}
