package ru.yandex.direct.internaltools.tools.feature.container;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class InternalToolsFeatureRole {
    @JsonProperty("Ключ фичи")
    private String textId;
    @JsonProperty("Роль")
    private String role;
    @JsonProperty("Доступ")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean state;

    public String getTextId() {
        return textId;
    }

    public InternalToolsFeatureRole withTextId(String textId) {
        this.textId = textId;
        return this;
    }

    public String getRole() {
        return role;
    }

    public InternalToolsFeatureRole withRole(String role) {
        this.role = role;
        return this;
    }

    public Boolean getState() {
        return state;
    }

    public InternalToolsFeatureRole withState(Boolean state) {
        this.state = state;
        return this;
    }
}
