package ru.yandex.direct.internaltools.tools.feature.container;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class InternalToolsFeatureRolesState extends InternalToolParameter {
    public static final String FEATURE_TEXT_ID = "FEATURE_TEXT_ID";
    public static final String ROLES = "ROLES";
    @Input(label = "Ключ фичи")
    private String textId;

    @Input(label = "Роли")
    @TextArea
    private String roles;

    @Input(label = "Доступ")
    @CheckBox(checked = true)
    private Boolean state;


    public Boolean getState() {
        return state;
    }

    public InternalToolsFeatureRolesState withState(Boolean state) {
        this.state = state;
        return this;
    }

    public String getTextId() {
        return textId;
    }

    public InternalToolsFeatureRolesState withTextId(String textId) {
        this.textId = textId;
        return this;
    }

    public String getRoles() {
        return roles;
    }

    public InternalToolsFeatureRolesState withRoles(String roles) {
        this.roles = roles;
        return this;
    }
}
