package ru.yandex.direct.internaltools.tools.feature.container;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class InternalToolsFeaturesViewOrDeleteParams extends InternalToolParameter {
    public enum SortType {
        BY_EXISTING_IN_DB("По отсутствию в базе"),
        BY_EXISTING_IN_CODE("По отсутствию в коде (FeatureName)"),
        BY_ID("По id"),
        BY_TEXT_ID("По ключу фичи"),
        BY_PERCENTS("По включению на 100%");

        private final String description;

        SortType(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    public enum Action {
        SHOW_FEATURES("Просмотр"),
        DELETE_ONE_FEATURE("Удалить одну фичу");

        private final String description;

        Action(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    @Select
    @Input(label = "Действие")
    private Action action;

    @Input(label = "Способ сортировки", required = false)
    private SortType sorting;

    @NumericId
    @Input(label = "Ключ фичи для удаления", required = false)
    private String featureTextId;

    public String getFeatureTextId() {
        return featureTextId;
    }

    public void setFeatureTextId(String featureTextId) {
        this.featureTextId = featureTextId;
    }

    public SortType getSorting() {
        return sorting;
    }

    public void setSorting(
            SortType sorting) {
        this.sorting = sorting;
    }

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

}
