package ru.yandex.direct.internaltools.tools.feature.container;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class InternalToolsLoginResponse {
    @JsonProperty("id клиента")
    private Long clientId;

    @JsonProperty("шеф логин")
    private String login;

    @JsonProperty("Доступ задан")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isPresent;

    @JsonProperty("Доступ")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isEnabled;

    public String getLogin() {
        return login;
    }

    public InternalToolsLoginResponse withLogin(String login) {
        this.login = login;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public InternalToolsLoginResponse withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Boolean getIsEnabled() {
        return isEnabled;
    }

    public InternalToolsLoginResponse withIsEnabled(Boolean enabled) {
        isEnabled = enabled;
        return this;
    }

    public Boolean getIsPresent() {
        return isPresent;
    }

    public InternalToolsLoginResponse withIsPresent(Boolean present) {
        isPresent = present;
        return this;
    }
}
