package ru.yandex.direct.internaltools.tools.feature.container;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class InternalToolsLoginWithChiefLoginResponse {
    @JsonProperty("ClientID")
    private Long clientId;

    @JsonProperty("login")
    private String login;

    @JsonProperty("login главного представителя")
    private String chiefLogin;

    @JsonProperty("Ключ фичи")
    private String textId;

    @JsonProperty("Доступ задан")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isPresent;

    @JsonProperty("Доступ")
    @Enrich(InternalToolDetailKey.BOOLEAN_REPLACE)
    private Boolean isEnabled;

    public String getLogin() {
        return login;
    }

    public InternalToolsLoginWithChiefLoginResponse withLogin(String login) {
        this.login = login;
        return this;
    }

    public String getChiefLogin() {
        return chiefLogin;
    }

    public InternalToolsLoginWithChiefLoginResponse withChiefLogin(String chiefLogin) {
        this.chiefLogin = chiefLogin;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public InternalToolsLoginWithChiefLoginResponse withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Boolean getIsEnabled() {
        return isEnabled;
    }

    public InternalToolsLoginWithChiefLoginResponse withIsEnabled(Boolean enabled) {
        isEnabled = enabled;
        return this;
    }

    public String getTextId() {
        return textId;
    }

    public InternalToolsLoginWithChiefLoginResponse withTextId(String textId) {
        this.textId = textId;
        return this;
    }

    public Boolean getIsPresent() {
        return isPresent;
    }

    public InternalToolsLoginWithChiefLoginResponse withIsPresent(Boolean present) {
        isPresent = present;
        return this;
    }
}
