package ru.yandex.direct.internaltools.tools.feature.container;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class InternalToolsViewOrDeleteFeatureInfo {

    public static final String TRUE_VALUE = "+";

    @JsonProperty("id фичи")
    private Long featureId;

    @JsonProperty("Есть в базе")
    private String existsInRepository;

    @JsonProperty("Есть в коде")
    private String existsInFeatureName;

    @JsonProperty("Ключ фичи")
    private String featureTextId;

    @JsonProperty("Тикет")
    @Enrich(InternalToolDetailKey.STARTREK_TICKET_LINK_REPLACE)
    private String featureTicket;

    @JsonProperty("Название")
    private String featurePublicName;

    @JsonProperty("Включена на 100%")
    private String isTurnOn;

    @JsonProperty("Клиенты вкл/выкл")
    private String clientSummary;

    @JsonProperty("Публичность")
    private String isPublic;

    public Long getFeatureId() {
        return featureId;
    }

    public InternalToolsViewOrDeleteFeatureInfo withId(Long id) {
        this.featureId = id;
        return this;
    }

    public String getExistsInRepository() {
        return existsInRepository;
    }

    public InternalToolsViewOrDeleteFeatureInfo withExistsInRepository(String existInRepository) {
        this.existsInRepository = existInRepository;
        return this;
    }

    public String getExistsInFeatureName() {
        return existsInFeatureName;
    }

    public InternalToolsViewOrDeleteFeatureInfo withExistsInFeatureName(String existInFeatureName) {
        this.existsInFeatureName = existInFeatureName;
        return this;
    }

    public String getFeatureTextId() {
        return featureTextId;
    }

    public InternalToolsViewOrDeleteFeatureInfo withFeatureTextId(String featureTextId) {
        this.featureTextId = featureTextId;
        return this;
    }

    public String getFeatureTicket() {
        return featureTicket;
    }

    public InternalToolsViewOrDeleteFeatureInfo withFeatureTicket(String featureTicket) {
        this.featureTicket = featureTicket;
        return this;
    }

    public String getFeaturePublicName() {
        return featurePublicName;
    }

    public InternalToolsViewOrDeleteFeatureInfo withFeaturePublicName(String featurePublicName) {
        this.featurePublicName = featurePublicName;
        return this;
    }

    public String getIsTurnOn() {
        return isTurnOn;
    }

    public InternalToolsViewOrDeleteFeatureInfo withIsTurnOn(String isTurnOn) {
        this.isTurnOn = isTurnOn;
        return this;
    }

    public String getClientSummary() {
        return clientSummary;
    }

    public InternalToolsViewOrDeleteFeatureInfo withClientSummary(String clientSummary) {
        this.clientSummary = clientSummary;
        return this;
    }

    public String getIsPublic() {
        return isPublic;
    }

    public InternalToolsViewOrDeleteFeatureInfo withIsPublic(String isPublic) {
        this.isPublic = isPublic;
        return this;
    }
}
