package ru.yandex.direct.internaltools.tools.feature.preprocessors;

import java.util.List;
import java.util.Set;

import com.google.common.collect.Iterables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

/**
 * Препроцессор, заменяющий допустимые значения в элементе ввода на список всех существующих на момент вызова фич
 */
@Component
public class AllFeatureNamesPreprocessor implements InternalToolInputPreProcessor<String> {
    private final FeatureService featureService;

    @Autowired
    public AllFeatureNamesPreprocessor(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        List<String> allFeatureIds = featureService.getAllExistingFeatureTextIds();
        List<String> sortedFeatureIds =
                allFeatureIds.stream()
                        .sorted()
                        .collect(toList());
        return inputBuilder
                .withDefaultValue(Iterables.getFirst(sortedFeatureIds, null))
                .withAllowedValues(sortedFeatureIds)
                .addValidator(inSet(Set.copyOf(sortedFeatureIds)));
    }
}
