package ru.yandex.direct.internaltools.tools.feature.tool;

import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolsClientIdLogin;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public abstract class AbstractClientFeaturesTool<R> extends MassInternalTool<InternalToolsClientIdLogin, R> {

    @Override
    public ValidationResult<InternalToolsClientIdLogin, Defect> validate(
            InternalToolsClientIdLogin internalToolsClientIdLogin) {
        ItemValidationBuilder<InternalToolsClientIdLogin, Defect> validationBuilder =
                ItemValidationBuilder.of(internalToolsClientIdLogin);
        validationBuilder.check(notNull());
        validationBuilder.checkByFunction(clientIdLogin -> {
            if (clientIdLogin.getClientId() != null
                    && (clientIdLogin.getLogin() != null && !"".equals(clientIdLogin.getLogin()))) {
                return CommonDefects.mustBeEmpty();
            }

            if (clientIdLogin.getClientId() == null
                    && (clientIdLogin.getLogin() == null || "".equals(clientIdLogin.getLogin()))) {
                return CommonDefects.notNull();
            }

            return null;
        });

        return validationBuilder.getResult();
    }
}
