package ru.yandex.direct.internaltools.tools.feature.tool;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.feature.service.FeatureManagingService;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Disclaimers;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolsFeatureFullDisableToolInput;

@Tool(
        name = "Полное выключение фичи",
        label = "feature_full_disable",
        description = "Выключить фичу всем, у кого она включена по идентификатору",
        consumes = InternalToolsFeatureFullDisableToolInput.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.TURN_OFF)
@Category(InternalToolCategory.FEATURES)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@Disclaimers({
        "Перед выключением фичи нужно закрыть возможность ее включить",
        "Полное выключение фичи может привести к непредсказуемым последствиям для тех, кто ее использует",
})
@ParametersAreNonnullByDefault
public class FeatureFullDisableTool implements BaseInternalTool<InternalToolsFeatureFullDisableToolInput> {
    private final FeatureManagingService clientFeatureService;

    @Autowired
    public FeatureFullDisableTool(FeatureManagingService clientFeatureService) {
        this.clientFeatureService = clientFeatureService;
    }

    @Override
    public InternalToolResult process(InternalToolsFeatureFullDisableToolInput input) {
        String message;
        if (!input.getApplyLicense()) {
            message = "Фича не была выключена, так как не были приняты условия лицензии";
        } else {
            clientFeatureService.switchFeatureOffForIdentifiedUsers(input.getName());
            message = "Фича успешно выключена для всех";
        }
        return new InternalToolResult()
                .withMessage(message);
    }
}
