package ru.yandex.direct.internaltools.tools.feature.tool;

import java.util.Collection;
import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.feature.service.FeatureManagingService;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolMassResult;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.exception.InternalToolValidationException;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolsFeaturePercent;
import ru.yandex.direct.result.Result;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.validation.ValidationUtils.hasValidationIssues;
import static ru.yandex.direct.internaltools.tools.feature.container.InternalToolsFeatureConverter.toFeatureToPercent;
import static ru.yandex.direct.internaltools.tools.feature.container.InternalToolsFeatureConverter.toInternalToolsFeaturePercentResponse;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Tool(
        name = "Обновление процента для фичи",
        label = "update_feature_percent",
        description = "Обновление процента для фичи",
        consumes = InternalToolsFeaturePercent.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.SET)
@Category(InternalToolCategory.FEATURES)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class FeaturePercentUpdateTool implements BaseInternalTool<InternalToolsFeaturePercent> {
    @Autowired
    private FeatureManagingService featureManagingServiceService;

    @Override
    public ValidationResult<InternalToolsFeaturePercent, Defect> validate(
            InternalToolsFeaturePercent internalToolsFeaturePercent) {
        ItemValidationBuilder<InternalToolsFeaturePercent, Defect> validationBuilder =
                ItemValidationBuilder.of(internalToolsFeaturePercent);
        validationBuilder.check(notNull());
        validationBuilder.item(internalToolsFeaturePercent.getTextId(), InternalToolsFeaturePercent.FEATURE_TEXT_ID)
                .check(notNull());
        validationBuilder.item(internalToolsFeaturePercent.getPercent(), InternalToolsFeaturePercent.PERCENT)
                .check(notNull());

        return validationBuilder.getResult();
    }

    @Override
    public InternalToolResult process(InternalToolsFeaturePercent internalToolsFeaturePercent) {
        Result<Collection<Long>> operationResult = featureManagingServiceService
                .updateFeaturePercent(Collections.singletonList(toFeatureToPercent(internalToolsFeaturePercent)));
        if (hasValidationIssues(operationResult)) {
            throw new InternalToolValidationException("").withValidationResult(operationResult.getValidationResult());
        }
        return new InternalToolMassResult<>(Collections.singletonList(toInternalToolsFeaturePercentResponse(
                internalToolsFeaturePercent)));

    }
}
