package ru.yandex.direct.internaltools.tools.feature.tool;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.feature.service.FeatureManagingService;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalToolWithoutParam;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolsFeature;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolsFeatureConverter;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Tool(
        name = "Список фич",
        label = "get_features",
        description = "Список текущих фич в закрытом бета-тестировании в Директе.",
        consumes = InternalToolParameter.class,
        type = InternalToolType.REPORT
)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.FEATURES)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPERREADER})
@ParametersAreNonnullByDefault
public class FeaturesGetTool extends MassInternalToolWithoutParam<InternalToolsFeature> {
    @Autowired
    private FeatureManagingService featureManagingService;

    @Override
    protected List<InternalToolsFeature> getMassData() {
        return mapList(featureManagingService.getFeatures(),
                InternalToolsFeatureConverter::toInternalToolsFeatureResponse);
    }
}
