package ru.yandex.direct.internaltools.tools.feature.tool;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.feature.container.ClientRealFeature;
import ru.yandex.direct.core.entity.feature.container.FeatureRequest;
import ru.yandex.direct.core.entity.feature.model.FeatureState;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.exception.InternalToolValidationException;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolsClientFeatureWithPublicName;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolsClientIdLogin;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.ValidationResult;

@Tool(
        name = "Список фич клиента",
        label = "get_features_for_client",
        description = "Получение списка фич, доступных клиенту",
        consumes = InternalToolsClientIdLogin.class,
        type = InternalToolType.REPORT
)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.FEATURES)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPERREADER,
        InternalToolAccessRole.SUPPORT})
public class GetClientsFeaturesTool extends AbstractClientFeaturesTool<InternalToolsClientFeatureWithPublicName> {
    @Autowired
    private FeatureService featureService;

    @Autowired
    private UserService userService;


    @Override
    protected List<InternalToolsClientFeatureWithPublicName> getMassData(InternalToolsClientIdLogin parameter) {
        ClientId clientId = null;

        if (parameter.getClientId() != null) {
            clientId = ClientId.fromLong(parameter.getClientId());
        } else if (parameter.getLogin() != null) {
            Long clientIdByLogin = userService.getClientIdByLogin(parameter.getLogin());
            if (clientIdByLogin == null) {
                throw new InternalToolValidationException("")
                        .withValidationResult(ValidationResult.failed(parameter.getLogin(), CommonDefects.invalidValue()));
            }
            clientId = ClientId.fromLong(clientIdByLogin);
        }
        return featureService
                .getAllKnownFeaturesForClient(new FeatureRequest().withClientId(clientId))
                .stream()
                .sorted(
                        Comparator.comparing((ClientRealFeature rcf) ->
                                rcf.getFeatureState() != FeatureState.ENABLED
                        ).thenComparing(rcf -> rcf.getFeature().getSettings().getPercent() > 0)
                ).map(crf -> new InternalToolsClientFeatureWithPublicName()
                        .withFeatureTextId(crf.getFeature().getFeatureTextId())
                        .withFeaturePublicName(crf.getFeature().getFeaturePublicName())
                        .withIsEnabled(crf.getFeatureState() == FeatureState.ENABLED)
                        .withIsPercent(
                                crf.getFeatureState() == FeatureState.DISABLED ? null :
                                        crf.getFeature().getSettings().getPercent() > 0
                        )
                ).collect(Collectors.toList());

    }
}
