package ru.yandex.direct.internaltools.tools.feature.tool;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.abt.container.UaasInfoRequest;
import ru.yandex.direct.core.entity.abt.service.UaasInfoService;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.exception.InternalToolValidationException;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolClientsUaasFeature;
import ru.yandex.direct.internaltools.tools.feature.container.InternalToolsClientIdLogin;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.ValidationResult;

@Tool(
        name = "Список фич клиента из uaas",
        label = "get_uaas_features_for_client",
        description = "Получение списка фич, заведенных через абшницу, доступных клиенту",
        consumes = InternalToolsClientIdLogin.class,
        type = InternalToolType.REPORT
)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.FEATURES)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPERREADER})
public class GetClientsUaasFeaturesTool extends AbstractClientFeaturesTool<InternalToolClientsUaasFeature> {
    @Autowired
    private UaasInfoService uaasInfoService;

    @Autowired
    private UserService userService;

    @Autowired
    private FeatureService featureService;

    @Override
    protected List<InternalToolClientsUaasFeature> getMassData(InternalToolsClientIdLogin parameter) {
        Long clientId = null;

        if (parameter.getClientId() != null) {
            clientId = ClientId.fromLong(parameter.getClientId()).asLong();
        } else if (parameter.getLogin() != null) {
            clientId = userService.getClientIdByLogin(parameter.getLogin());
            if (clientId == null) {
                throw new InternalToolValidationException("")
                        .withValidationResult(ValidationResult.failed(parameter.getLogin(), CommonDefects.invalidValue()));
            }
        }

        Set<String> enabledFeatures = featureService.getEnabledForClientId(ClientId.fromLong(clientId));

        return uaasInfoService
                .getInfo(new UaasInfoRequest()
                        .withClientId(clientId)
                        .withEnabledFeatures(enabledFeatures))
                .getTests()
                .stream()
                .map(testInfo -> new InternalToolClientsUaasFeature()
                        .withFeatures(testInfo.getFeatures())
                        .withTestId(testInfo.getTestIds().isEmpty() ? "" : testInfo.getTestIds().get(0))
                        .withCondition(testInfo.getCondition())
                ).collect(Collectors.toList());

    }
}
